//flash.c for RTOS_Serial Project
//Rob Silbert Limited, LLC

//http://mysite.verizon.net/vze124b2u/
//Written by Rob Silbert
//rsilbert@yahoo.com
//mobile: 

/*
	This file is part of pqrst commander.

    pqrst commander is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pqrst commander is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pqrst commander.  If not, see <http://www.gnu.org/licenses/>.
*/
/*
	mw
	if
	loop
	app
	temp ap 
	print

*/
#include <msp430x14x.h>
//#include <stdio.h>
//#include <in430.h>
#include "commander.h "
/*****************************************************
*                                                    *
*                 	FlashInit			             *
*                                                    *
******************************************************/	

void FlashInit(void)
{
	FCTL2 = (FWKEY | FSSEL_1 | FN0);
	//FCTL3 = FWKEY;
}

/*****************************************************
*                                                    *
*                 	FlashRead			             *
*                                                    *
******************************************************/	

unsigned char FlashRead(unsigned char *address)
{
	//unsigned char *flash_pointer;
	unsigned char return_byte;
	FCTL1 = FWKEY;
	FCTL3 = FWKEY;
	//_NOP();
	return_byte = *address;
	FCTL1 = FWKEY;						//reset lock
	FCTL3 = FWKEY + LOCK;				//reset write
	return return_byte;
}

/*****************************************************
*                                                    *
*                 	FlashWrite			             *
*                                                    *
******************************************************/	

void FlashWrite(unsigned char *address, unsigned char byte_to_write)
{
	_DINT();							//Must disable interrupts when writing to flash
	while(FCTL3 & (BUSY|LOCK));
	FCTL1 = FWKEY + WRT;
	FCTL3 = FWKEY;
	*address = byte_to_write;
	FCTL3 = FWKEY;						//reset lock
	FCTL1 = FWKEY + LOCK;				//reset write
	_EINT();
}

/*****************************************************
*                                                    *
*                 	FlashErase 			             *
*                                                    *
******************************************************/
void FlashErase(unsigned char *address)
{
	_DINT();
	FCTL1 = FWKEY + ERASE;
	FCTL3 = FWKEY;
	while(FCTL3 & (BUSY|LOCK));
	*address = 1;				//Dummy write to erase segment
	FCTL3 = FWKEY;				//reset lock
	FCTL1 = FWKEY;				//reset ERASE
	_EINT();
}

/*****************************************************
*                                                    *
*              UARTDataReceivedInterrupt         	 *
*                                                    *
******************************************************/
interrupt[UART0RX_VECTOR] void usart0_rx (void)
{
	extern unsigned char receive_counter;
	extern char receive_buffer[32],configFile[256],receiveMode;
	if(receiveMode == COMMAND)
		receive_buffer[receive_counter] = RXBUF0;
	if(receiveMode == CONFIG)
		configFile[receive_counter] = RXBUF0;
	receive_counter++;	 
}

/*****************************************************
*                                                    *
*                  WriteUARTData                     *
*                                                    *
******************************************************/
unsigned char WriteUARTData(unsigned char data_byte)
{
	//unsigned char i;
	//do{
	TXBUF0 = data_byte;
	//OSSignalSem(SEM_CHAR);
	return 0;
	//} while(0);
}

/*****************************************************
*                                                    *
*                  UARTPrint                     	 *
*                                                    *
******************************************************/
void UARTPrint(unsigned char *textToPrint)
{
 static unsigned char i;
 i=0;
 while(textToPrint[i])
 {
	if(textToPrint[i] == LINEFEED)
	{
	 	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData(0x0d);
		while((IFG1 & UTXIFG0) == 0);
		WriteUARTData(0x0a);
 	}
	else if(textToPrint[i] == CARRIAGERETURN)
	{
		while((IFG1 & UTXIFG0) == 0);
		WriteUARTData(0x0d);
	}
	else
	{
		while((IFG1 & UTXIFG0) == 0);
		WriteUARTData(textToPrint[i]);
	}
	i++;
 }
}

/*****************************************************
*                                                    *
*                  UARTShutdown                      *
*                                                    *
******************************************************/
/*
void UARTShutdown(void)
{
	UCTL0 |= SWRST;
	_BIS_SR(SCG1);			//Disable SMCLK
	//UTCTL0 &= ~SSEL0;		// UCLK = SMCLK
	//UTCTL0 &= ~SSEL1;		// 0 = UCLK, 1 = ACLK, 2,3 = SMCLK
	UTCTL0 &= ~(SSEL0 | SSEL1);
	UBR00 = 0x00;			// Baudrate = BRCLK / UxBR = 3.58MHz / 19,200 = 186.46 = 0xBA
	UBR10 = 0x00;			//
	UMCTL0 = 0x00;			// No Modulation
	ME1 &= ~UTXE0 + ~URXE0;	// Disable USART0 TXD/RXD
	IE1 &= ~URXIE0;			// Disable USART0 RX Interrupt
	P3SEL = 0x00;			
	//P3OUT &= ~BIT2;
	P3OUT = 0xC2;
	P2OUT |= BIT7;
}
*/
